<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class newpasswordNotification extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     */
    public $newpassword;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($newpassword)
    {
        $this->newpassword = $newpassword;
    }


    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Welcome to ' . config('app.name'))
            ->line('Your new password is '. $this->newpassword)
            // ->line('investment packages that fit your budget plan with great returns. This is the best place to be at the moment. ')
            ->line('Contact us immediately if you did not authorize this registration.')
            ->line('Thank you for choosing us.')
            ->line('Regards,')
            ->line('Team '. ucfirst(config('app.name')));
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
